﻿/*
VERSION:		1.0
	
USAGE:
	#include "walkJoystickInertia.as"
	walk_obj = makeWalk( player_mc );
	
	onUnload = function(){
		clearInterval(walk_obj.loopInterval);
	}
	
NOTE:
	This requires MDM Zinc to read the Joystick.
	This system can also use the keyboard.
	To read the joystick, you must re-compile your SWF using Zinc.
	
NOTE:
	This system has hooks for these collision and sprite systems:
		sprite.as					(Sprite system 2)
		WalkCollision.as
	
ADDING COLLISION:
	A collision system can be added like this:
		walk_obj.collision = new Collision( player_mc, walk_obj, collision_array, -8, -8 );
	The walk_obj is this walk system.
*/
makeWalk = function( player_mc, playerImage_mc )
{
	// create container
	var _this = new Object();
	
	// Enable joystick
	mdm.Input.Joystick.enable( 1, "mouse" );		// Use "mouse" mode to keep the cursor within the window
	mdm.Input.Mouse.hide("MainForm");			// hide the mouse cursor
	
	// walkSpeed
	_this.walkSpeed = 3;			// top speed
	_this.acel = 1.2;					// acelleration increment
	_this.decel = 0.5;				// brake multiplier
	_this.deadZone = 10;			// Analog stick dead-zone.  Movement below this magnatude is ignored.
	/*
	// icey conditions
	_this.acel = 0.2;					// acelleration increment
	_this.decel = 0.95;				// brake multiplier
	*/
	
	_this.xVel = 0;					// How many pixels to move during this frame  (acts more like tiles per frame);
	_this.yVel = 0;					// 
	
	//default walk buttons.  This allows the keys to be changed externally.
	_this.up_key = Key.UP;
	_this.down_key = Key.DOWN;
	_this.left_key = Key.LEFT;
	_this.right_key = Key.RIGHT;
	
	
	
	// Make a looping function
	_this.loop = function()
	{
		// detect vert keys
		if( Key.isDown(_this.down_key) )
		{
			playerImage_mc.setParams({direction:"down"});
			if(_this.yVel < _this.walkSpeed)
			{
				_this.yVel += _this.acel;
			}
		}
		else if( _root.mdm_joystick1_ylevel > 0  &&  Math.abs(_root.mdm_joystick1_ylevel) > _this.deadZone )
		{
			if( Math.abs(_root.mdm_joystick1_xlevel) < Math.abs(_root.mdm_joystick1_ylevel) )
			{
				playerImage_mc.setParams({direction:"down"});
			}
			_this.yVel += _this.acel * (_root.mdm_joystick1_ylevel / 100);
			var maxSpeed = _this.walkSpeed * Math.abs(_root.mdm_joystick1_ylevel / 100);
			if(_this.yVel > maxSpeed)
			{
				_this.yVel = maxSpeed;
			}
		}
		else if( Key.isDown(_this.up_key))
		{
			playerImage_mc.setParams({direction:"up"});
			if(_this.yVel > -_this.walkSpeed)
			{
				_this.yVel -= _this.acel;
			}
		}
		else if( _root.mdm_joystick1_ylevel < 0  &&  Math.abs(_root.mdm_joystick1_ylevel) > _this.deadZone )
		{
			if( Math.abs(_root.mdm_joystick1_xlevel) < Math.abs(_root.mdm_joystick1_ylevel) )
			{
				playerImage_mc.setParams({direction:"up"});
			}
			_this.yVel += _this.acel * (_root.mdm_joystick1_ylevel / 100);
			var maxSpeed = _this.walkSpeed * Math.abs(_root.mdm_joystick1_ylevel / 100);
			if(_this.yVel < -maxSpeed)
			{
				_this.yVel = -maxSpeed;
			}
		}
		else
		{
			// decellerate
			if(Math.abs(_this.yVel) > 1)
			{
				_this.yVel *= _this.decel;
			}else{
				_this.yVel = 0;
			}
		}
		
		
		
		// detect horz keys
		if( Key.isDown(_this.right_key) )
		{
			playerImage_mc.setParams({direction:"right"});
			if(_this.xVel < _this.walkSpeed)
			{
				_this.xVel += _this.acel;
			}
		}
		else if( _root.mdm_joystick1_xlevel > 0  &&  Math.abs(_root.mdm_joystick1_xlevel) > _this.deadZone )
		{
			if( Math.abs(_root.mdm_joystick1_xlevel) > Math.abs(_root.mdm_joystick1_ylevel) )
			{
				playerImage_mc.setParams({direction:"right"});
			}
			_this.xVel += _this.acel * (_root.mdm_joystick1_xlevel / 100);
			var maxSpeed = _this.walkSpeed * Math.abs(_root.mdm_joystick1_xlevel / 100);
			if(_this.xVel > maxSpeed)
			{
				_this.xVel = maxSpeed;
			}
		}
		else if( Key.isDown(_this.left_key))
		{
			playerImage_mc.setParams({direction:"left"});
			if(_this.xVel > -_this.walkSpeed)
			{
				_this.xVel -= _this.acel;
			}
		}
		else if( _root.mdm_joystick1_xlevel < 0  &&  Math.abs(_root.mdm_joystick1_xlevel) > _this.deadZone )
		{
			if( Math.abs(_root.mdm_joystick1_xlevel) > Math.abs(_root.mdm_joystick1_ylevel) )
			{
				playerImage_mc.setParams({direction:"left"});
			}
			_this.xVel += _this.acel * (_root.mdm_joystick1_xlevel / 100);
			var maxSpeed = _this.walkSpeed * Math.abs(_root.mdm_joystick1_xlevel / 100);
			if(_this.xVel < -maxSpeed)
			{
				_this.xVel = -maxSpeed;
			}
		}
		else
		{
			// decellerate
			if(Math.abs(_this.xVel) > 1)
			{
				_this.xVel *= _this.decel;
			}else{
				_this.xVel = 0;
			}
		}
		
		
		
		// Apply externally-defined collision
		_this.collision.run();
		
		// adjust walk speed
		var max = 5;					// slowest animation speed
		var range = 4;				// how much animation can speed up
		var topSpeed = 10;		// movement velocity where animation is at top-speed
		var moveSpeed = (Math.abs(_this.xVel)>Math.abs(_this.yVel)) ? Math.abs(_this.xVel) : Math.abs(_this.yVel);		// Use the fastest velocity
		var speedPercent = Math.abs(moveSpeed) / topSpeed;		// get percent
		var animSpeed = max - (range * speedPercent);
		var animSpeed = (animSpeed<1) ? 1 : animSpeed;		// enforce max speed
		playerImage_mc.setParams({delay:animSpeed});
		
		// start or stop the walk animation
		if ( Math.abs(_this.xVel) <= 0.05  &&
			 Math.abs(_this.yVel) <= 0.05 )
		{
			// is not moving
			playerImage_mc.setParams({isAnimating:false});
		}else{
			// is moving
			playerImage_mc.setParams({isAnimating:true});
		}
		
		// Move the player
		player_mc._x += _this.xVel;
		player_mc._y += _this.yVel;
		
	}// loop()
	_this.loopInterval = setInterval( _this.loop, 1000/30 );
	
	
	
	// return this system
	return _this;
}// makeWalk()